﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;

public class PowerBullets : MonoBehaviour {

    public static PowerBullets instance;

    public float onPowerBulletsTime;
    
    public Image imageTimer;
    
    bool collided = false;

	void Awake () {
       
    }

    void MakeInstance() {
        if(instance == null) {
            instance = this;
        }
    }

	void Update () {
//        timerText.text = "Bullet Timer : " + onPowerBulletsTime;
        imageTimer.fillAmount = onPowerBulletsTime / 20f;

        if (collided) {
            onPowerBulletsTime -= Time.deltaTime;            
        }

        if (onPowerBulletsTime >= 0.1f) {
            PowerBulletOn();
        }

        if(onPowerBulletsTime <= 0f) {
            PowerBulletOff();
            onPowerBulletsTime = 0f;
        }
    }

    void OnCollisionEnter2D(Collision2D collision) {
        
    }

    void OnTriggerEnter2D(Collider2D collision) {
        if (collision.tag == "PowerBullet") {
            collided = true;
            onPowerBulletsTime = 20f;
            ScoreCount.instance.CountScore(+10);
            Destroy(collision.gameObject);
        }
    }

    void PowerBulletOn() {
        try {
            PlayerShoot.instance.spawn1.SetActive(true);
        } catch (MissingReferenceException) {

        }

        try {
            PlayerShoot.instance.spawn3.SetActive(true);
        } catch (MissingReferenceException) {

        }

    }
    
    void PowerBulletOff() {
        try {
            PlayerShoot.instance.spawn1.SetActive(false);
        } catch (MissingReferenceException) {

        }

        try {
            PlayerShoot.instance.spawn3.SetActive(false);
        } catch (MissingReferenceException) {

        }
        
    }
}